package gov.va.vinci.dart.json;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="activity")
@XmlType(name="activity", propOrder={
		"activityId",
		"type",
		"officialName",
		"shortName",
		"requestSubmittedDate",
		"activityStartDate",
		"activityEndDate",
		"iRBApprovalNumber",
		"iRBExpirationDate",
		"trackingNumber",
		"requestor",
		"initiatedDate",
		"editable",
		"principalInvestigator",
		"programOffice",
		"justification",
		"expectedIRBSubmissionDate"
})
public class ActivityView {
	private int activityId;
	private String type;
	private String officialName;
	private String shortName;
	private String requestSubmittedDate;
	private String activityStartDate;
	private String activityEndDate;
	private String iRBApprovalNumber;
	private String iRBExpirationDate;
	private String trackingNumber;
	private String requestor;
	private String initiatedDate;
	private boolean editable;
	private String principalInvestigator;
	private String programOffice;  // only for operational request
	private String justification;  // only for operational request
	private String expectedIRBSubmissionDate;

	private List<ActivityParticipantView> participantList = new ArrayList<ActivityParticipantView>();

	public List<ActivityParticipantView> getParticipantList() {
		return participantList;
	}

	public int getActivityId() {
		return activityId;
	}

	public void setActivityId(int activityId) {
		this.activityId = activityId;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getOfficialName() {
		return officialName;
	}

	public void setOfficialName(String officialName) {
		this.officialName = officialName;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getActivityStartDate() {
		return activityStartDate;
	}

	public void setActivityStartDate(String activityStartDate) {
		this.activityStartDate = activityStartDate;
	}

	public String getActivityEndDate() {
		return activityEndDate;
	}

	public void setActivityEndDate(String activityEndDate) {
		this.activityEndDate = activityEndDate;
	}

	public String getiRBApprovalNumber() {
		return iRBApprovalNumber;
	}

	public void setiRBApprovalNumber(String iRBApprovalNumber) {
		this.iRBApprovalNumber = iRBApprovalNumber;
	}

	public String getiRBExpirationDate() {
		return iRBExpirationDate;
	}

	public void setiRBExpirationDate(String iRBExpirationDate) {
		this.iRBExpirationDate = iRBExpirationDate;
	}

	public String getTrackingNumber() {
		return trackingNumber;
	}

	public void setTrackingNumber(String trackingNumber) {
		this.trackingNumber = trackingNumber;
	}

	public String getRequestor() {
		return requestor;
	}

	public void setRequestor(String requestor) {
		this.requestor = requestor;
	}

	public String getInitiatedDate() {
		return initiatedDate;
	}

	public void setInitiatedDate(String initiatedDate) {
		this.initiatedDate = initiatedDate;
	}

	public boolean isEditable() {
		return editable;
	}

	public void setEditable(boolean editable) {
		this.editable = editable;
	}

	public String getPrincipalInvestigator() {
		return principalInvestigator;
	}

	public void setPrincipalInvestigator(String principalInvestigator) {
		this.principalInvestigator = principalInvestigator;
	}
	
	public String getProgramOffice() {
		return programOffice;
	}

	public void setProgramOffice(String programOffice) {
		this.programOffice = programOffice;
	}

	public String getJustification() {
		return justification;
	}

	public void setJustification(String justification) {
		this.justification = justification;
	}

	public String getRequestSubmittedDate() {
		return requestSubmittedDate;
	}

	public void setRequestSubmittedDate(String requestSubmittedDate) {
		this.requestSubmittedDate = requestSubmittedDate;
	}

    public String getExpectedIRBSubmissionDate() {
        return expectedIRBSubmissionDate;
    }

    public void setExpectedIRBSubmissionDate(String expectedIRBSubmissionDate) {
        this.expectedIRBSubmissionDate = expectedIRBSubmissionDate;
    }	
}
